****************************************************************
*This program uses local projectiosn to produce Figure 18 Response of Mortgage Payments to Monetary Policy Shock 	
****************************************************************
clear 
import excel "`location'\Lending indicator.xlsx", sheet("Sheet1") firstrow
sort Date 

g q = 1 if month < 4
replace q = 2 if month > 3
replace q = 3 if month > 6
replace q = 4 if month > 9



gen housingcredit_dinc_q=housing_credit/HHDYannual*100
drop if housingcredit_dinc==.

gen inflow_dinc_q=newloan_abs_q/HHDYannual*100
gen outflow_dinc_q=outflow_q/HHDYannual*100


g period = yq(year,quarter)
format %tq period

tsset period

gen housingcredit_dinc_q_lag=l1.housingcredit_dinc_q
gen inflow_dinc_q_lag=l1.inflow_dinc_q
gen outflow_dinc_q_lag=l1.outflow_dinc_q


******************
*LOCAL PROJECTIONS
******************
*repeat for each of the following variables: 
* housing credit to disposable income: housingcredit_dinc_q
* inflow to disposable income: inflow_dinc_q
* outflow to disposable income: outflow_dinc_q
* graph data are 'horizon b u d' 
gen b=0
gen u=0
gen d=0

foreach x in housingcredit_dinc_q  {
forv h = 0/20 {
gen `x'`h' = f`h'.`x' - l.`x' 			// Use for cumulative IRF

}
}


cap drop b u d Years Zero
gen horizon = _n-1 if _n<=21
gen zero =  0    if _n<=21

forv h = 0/19{
bootstrap, rep (100): reg housingcredit_dinc_q`h' mpshock_q i.q housingcredit_dinc_q_lag, robust

replace b = _b[mpshock_q]                     if _n == `h'+2
replace u = _b[mpshock_q] + 1.645* _se[mpshock_q]  if _n == `h'+2
replace d = _b[mpshock_q] - 1.645* _se[mpshock_q]  if _n == `h'+2

}



		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
/*		
order u d b horizon zero 
outsheet using "oecd_lp.csv", replace comma
